/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.util.properties.Properties;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class ExplosiveReaction
implements IReaction {
    public static final IReaction EXPLOSION = new ExplosiveReaction(4.0f, Explosion.Mode.NONE);
    public static final IReaction HE_EXPLOSION = new ExplosiveReaction(5.0f, Explosion.Mode.NONE);
    public static final IReaction DESTRUCTIVE_EXPLOSION = new ExplosiveReaction(4.0f, Explosion.Mode.DESTROY);
    private final float explosionPower;
    private final Explosion.Mode mode;

    public ExplosiveReaction(float explosionPower, Explosion.Mode mode) {
        this.explosionPower = explosionPower;
        this.mode = mode;
    }

    @Override
    public void react(AbstractProjectile projectile, Vector3d impact, World world) {
        if (!world.field_72995_K) {
            float power = (float)projectile.getProperty(Properties.EXPLOSION_POWER).intValue() + this.explosionPower;
            boolean allowGriefing = world.func_82736_K().func_223586_b(GameRules.field_223599_b);
            world.func_217385_a((Entity)projectile, impact.field_72450_a, impact.field_72448_b, impact.field_72449_c, power, allowGriefing ? this.mode : Explosion.Mode.NONE);
        }
    }
}

